function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 47);

T(1) = params(14)/100;
T(2) = (1+params(13)/100)/(1+params(15)/100)/(1+T(1))^(-params(6));
T(3) = (1+T(1))^(-params(6))*T(2)*y(76)/y(29);
T(4) = 1.01^(1-params(6))-1;
T(5) = (1+T(1))^(1-params(6));
T(6) = T(2)*T(5);
T(7) = y(21)-params(7)*y(1)/(1+T(1));
T(8) = T(7)^(1-params(6))/(1-params(6));
T(9) = exp((params(6)-1)*y(22)^(1+params(29))/(1+params(29)));
T(10) = (1-params(6))*T(2)*params(7)*y(71)/T(5);
T(11) = y(73)^2;
T(12) = T(3)*y(79)*y(75)*T(11);
T(13) = y(22)^params(29);
T(14) = 1/(1-1/params(5));
T(15) = y(81)^params(5);
T(16) = y(36)^(params(5)*params(12));
T(17) = T(15)/T(16);
T(18) = y(36)^(params(12)*(params(5)-1));
T(19) = T(18)*y(80);
T(20) = T(15)/T(19);
T(21) = y(8)^params(12);
T(22) = T(21)/y(37);
T(23) = y(37)^params(5);
T(24) = y(8)^(params(5)*params(12));
T(25) = (y(40)*y(46))^params(2);
T(26) = y(2)/(1+T(1));
T(27) = T(26)^(1-params(2));
T(28) = 1/(1-1/params(4));
T(29) = T(28)*y(50);
T(30) = y(80)^params(4);
T(31) = y(36)^(params(4)*params(11));
T(32) = T(30)/T(31);
T(33) = y(80)^(params(4)-1);
T(34) = y(36)^(params(11)*(params(4)-1));
T(35) = T(33)/T(34);
T(36) = y(8)^params(11);
T(37) = T(36)/y(36);
T(38) = y(36)^params(4);
T(39) = y(8)^(params(4)*params(11));
T(40) = y(35)/(steady_state(18));
T(41) = y(7)/(steady_state(18));
T(42) = y(36)/(steady_state(19));
T(43) = y(50)/(steady_state(33));
T(44) = y(50)/y(13);
T(45) = (1+T(1))*y(21)/y(1);
T(46) = (1+T(1))*y(26)/y(3);
T(47) = (1+T(1))*y(38)/y(9);

end
